/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.internal;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.contentassist.JSLocationIdentifier;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.index.core.Index;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSModelUtil {
    private JSModelUtil() {
    }

    public static Collection<PropertyElement> getProperties(AbstractThemeableEditor editor, IParseNode node) {
        JSIndexQueryHelper queryHelper = JSModelUtil.createQueryHelper(editor);
        JSLocationIdentifier identifier = new JSLocationIdentifier(node.getStartingOffset() + 1, node);
        switch (identifier.getType()) {
            case IN_GLOBAL: 
            case IN_CONSTRUCTOR: 
            case IN_VARIABLE_NAME: 
            case IN_VARIABLE_DECLARATION: {
                String fileName = EditorUtil.getFileName((IEditorPart)editor);
                return queryHelper.getGlobals(fileName, node.getText());
            }
            case IN_PROPERTY_NAME: {
                Index index = EditorUtil.getIndex((AbstractThemeableEditor)editor);
                JSGetPropertyNode propertyNode = ParseUtil.getGetPropertyNode(identifier.getTargetNode(), identifier.getStatementNode());
                List<String> types = ParseUtil.getReceiverTypeNames(queryHelper, index, EditorUtil.getURI((IEditorPart)editor), identifier.getTargetNode(), propertyNode, node.getStartingOffset());
                String typeName = null;
                String methodName = null;
                if (!CollectionsUtil.isEmpty(types)) {
                    typeName = types.get(0);
                    methodName = propertyNode.getLastChild().getText();
                }
                if (typeName == null || methodName == null) break;
                return queryHelper.getTypeMembers(typeName, methodName);
            }
        }
        return Collections.emptyList();
    }

    public static JSIndexQueryHelper createQueryHelper(AbstractThemeableEditor editor) {
        IProject project = EditorUtil.getProject((AbstractThemeableEditor)editor);
        if (project != null) {
            return new JSIndexQueryHelper(project);
        }
        return new JSIndexQueryHelper(EditorUtil.getIndex((AbstractThemeableEditor)editor));
    }
}

